'use client';

import { DashboardHeader } from '@/components/dashboard/header';
import { KpiView } from '@/components/dashboard/kpi-view';
import { InventoryProvider } from '@/components/providers/inventory-provider';

export type InventoryData = Record<string, string | number>;

function DashboardContent() {
  return (
    <div className="flex min-h-screen w-full flex-col bg-muted/40">
      <DashboardHeader />
      <main className="flex flex-1 flex-col gap-4 p-4 md:gap-8 md:p-8">
        <KpiView />
      </main>
    </div>
  );
}

export default function Dashboard() {
  return (
    <InventoryProvider>
      <DashboardContent />
    </InventoryProvider>
  );
}
